﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.Diagnostics;
using System.ServiceModel.Dispatcher;


namespace ServiceModelEx
{
   class SecurityCallStackInterceptor : GenericInvoker
   {
      public SecurityCallStackInterceptor(IOperationInvoker oldInvoker) : base(oldInvoker)
      {}

      protected override void PreInvoke(object instance,object[] inputs)
      {
         try
         {
            SecurityCallStack callStack = SecurityCallStackContext.Current;
            if(callStack != null)
            {
               LogCallChain(callStack);
               ValidateCallChain(callStack);
               SignCallChain(callStack);
            }
         }
         catch(NullReferenceException)
         {
            throw new InvalidOperationException("No security call stack was found. Are you using the right proxy?");
         }
      }

      void ValidateCallChain(SecurityCallStack callStack)
      {
         // Tutaj należy wykonać niestandardowe testy sprawdzające
      }

      void SignCallChain(SecurityCallStack callStack)
      {
         // Tutaj należy cyfrowo podspisać stos wywołań
      }
      void LogCallChain(SecurityCallStack callStack)
      {
         // Tutaj należy zapisać stan stosu wywołań w dzienniku. Na przykład:
         foreach(SecurityCallFrame call in callStack.Calls)
         {
            Trace.Write("ID aktywności = " + call.ActivityId + ",");
            Trace.Write(" Adres = " + call.Address + ",");
            Trace.Write(" Uwierzytelnianie = " + call.Authentication + ",");
            Trace.Write(" Godzina = " + call.CallTime + ",");
            Trace.Write(" Tożsamość = " + call.IdentityName + ",");
            Trace.Write(" Operacja = " + call.Operation + ",");
            Trace.WriteLine(" Wywołujący = " + call.CallerType);
         }
      }
   }

   public class OperationSecurityCallStackAttribute : OperationInterceptorBehaviorAttribute
   {
      protected override GenericInvoker CreateInvoker(IOperationInvoker oldInvoker)
      {
         return new SecurityCallStackInterceptor(oldInvoker);
      }
   }
   public class SecurityCallStackBehaviorAttribute : ServiceInterceptorBehaviorAttribute
   {
      protected override OperationInterceptorBehaviorAttribute CreateOperationInterceptor()
      {
         return new OperationSecurityCallStackAttribute();
      }
   }
}